#include "hex.h"
#include <util/string/hex.h>

namespace {
    const char* hexChar = "0123456789ABCDEF";
}

TString Ui64ToHex(ui64 value, ui32 len) {
    TString result = "";
    while (value) {
        result = (TString)::hexChar[value & ((1 << 4) - 1)] + result;
        value >>= 4;
    }
    while (result.size() < len)
        result = "0" + result;
    return result;
}

ui64 HexToui64(const char* hex, size_t maxLen) {
    ui64 result = 0;
    size_t i = 0;
    int d = 0;
    while (i < maxLen && hex[i] && d >= 0) {
        try {
            d = Char2Digit(hex[i++]);
        }
        catch (...) {
            break;
        }
        result = result << 4;
        result |= d;
    }
    return result;
}
