#pragma once
#include <util/generic/string.h>

TString Ui64ToHex(ui64 value, ui32 len = 10);
ui64 HexToui64(const char* hex, size_t maxLen = 1024);

template <class T>
TString DecToBinStr(const T dec) {
    TString result;
    T decMutable = dec;
    for (ui32 i = 0; i < sizeof(T) * 8; ++i) {
        result = ToString(decMutable % 2) + result;
        decMutable >>= 1;
    }
    return result;
}

