#pragma once

#include <library/cpp/json/json_value.h>
#include <library/cpp/json/json_writer.h>

#include <contrib/libs/mongo-c-driver/libbson/src/bson/bson.h>

namespace NUtil {
    namespace NPrivate {
        class TBson {
        public:
            TBson(const NJson::TJsonValue& json)
                : Bson(bson_new_from_json(reinterpret_cast<const uint8_t*>(NJson::WriteJson(json, false).data()), -1, nullptr))
            {}

            const bson_t* Get() const {
                return Bson;
            }

            ~TBson() {
                if (!!Bson)
                    bson_destroy(Bson);
            }

        private:
            bson_t* Bson;
        };
    }
}
