#pragma once

#include "collection.h"
#include "gridfs.h"

#include <util/system/defaults.h>
#include <util/generic/map.h>


namespace NUtil {
    class TMongoConnectionsPool;

    class TMongoConnection {
    public:
        TMongoConnection(const TString& uri);
        TMongoConnection(TMongoConnectionsPool* pool);
        ~TMongoConnection();

        TMongoCollection& GetCollection(const TString& db, const TString& collection);
        TMongoGridFs& GetGridFs(const TString& db, const TString& collection);
        mongoc_client_t* GetRawConnection();

    private:
        mongoc_client_t* Client;
        mongoc_uri_t* Uri;
        TMongoConnectionsPool* Pool;
        TMap<TString, TMongoCollection::TPtr> ActiveCollections;
        TMap<TString, TMongoGridFs::TPtr> ActiveFs;
    };
}
