#pragma once

#include <library/cpp/deprecated/atomic/atomic.h>

#include <util/generic/singleton.h>
#include <util/generic/map.h>
#include <util/system/mutex.h>

namespace NUtil {

    class TMongoConnection;
    class TMongoConnectionsPool;

    class TMongoEngine {
        Y_DECLARE_SINGLETON_FRIEND();

    public:
        using TConnectionPtr = TAtomicSharedPtr<TMongoConnection>;
        using TConnectionsPoolPtr = TAtomicSharedPtr<TMongoConnectionsPool>;

        static TConnectionPtr CreateConnection(const TString& host, const ui16 port);
        static TConnectionPtr CreateConnection(const TString& uri);
        static TConnectionsPoolPtr CreateConnectionsPool(const TString& uri);

        static void ReleaseConnection();
        static void RegisterConnection();

        ~TMongoEngine();

    private:
        TMongoEngine();
        TConnectionPtr CreateConnectionPrivate(const TString& uri);
        TConnectionsPoolPtr CreateConnectionsPoolPrivate(const TString& uri);
        static TMongoEngine& Instance();

        TAtomic Connections;
    };

}
