#pragma once

#include "collection.h"

#include <contrib/libs/mongo-c-driver/libmongoc/src/mongoc/mongoc.h>

#include <util/generic/fwd.h>
#include <util/generic/ptr.h>

class TBlob;

namespace NJson {
    class TJsonValue;
}

namespace NUtil {

    class TMongoConnection;

    class TMongoGridFs {
    public:
        using TPtr = TAtomicSharedPtr<TMongoGridFs>;

        TMongoGridFs(TMongoConnection* connection, const TString& db, const TString& fs);
        ~TMongoGridFs();

        void PutFile(const TString& filename, const TBlob& fileData, const NJson::TJsonValue& metadata);
        void RemoveFile(const TString& filename);
        TBlob GetFile(const NJson::TJsonValue& query) const;
        TMongoCollection::TIterator::TPtr FindFileInfo(const NJson::TJsonValue& query);
        mongoc_gridfs_t* GetRawFs();

    private:
        mongoc_gridfs_t* GridFs;
        TMongoCollection::TPtr FilesMeta;
    };
}
