#include "pool.h"
#include "connection.h"

namespace NUtil {

    TMongoConnectionsPool::TMongoConnectionsPool(const TString& uri) {
        Uri = mongoc_uri_new(uri.data());
        Pool = mongoc_client_pool_new(Uri);
    }

    TMongoConnectionsPool::~TMongoConnectionsPool() {
        mongoc_client_pool_destroy(Pool);
        mongoc_uri_destroy(Uri);
    }

    TAtomicSharedPtr<TMongoConnection> TMongoConnectionsPool::GetConection() {
        return new TMongoConnection(this);
    }

    mongoc_client_t* TMongoConnectionsPool::PopRawClient() {
        return mongoc_client_pool_pop(Pool);
    }

    void TMongoConnectionsPool::PushRawClient(mongoc_client_t* client) {
        mongoc_client_pool_push(Pool, client);
    }
}
