#pragma once

#include <util/system/defaults.h>
#include <util/generic/string.h>
#include <util/generic/ptr.h>
#include <contrib/libs/mongo-c-driver/libmongoc/src/mongoc/mongoc.h>

namespace NUtil {

    class TMongoConnection;

    class TMongoConnectionsPool {
    public:
        TMongoConnectionsPool(const TString& uri);
        ~TMongoConnectionsPool();

        TAtomicSharedPtr<TMongoConnection> GetConection();
        mongoc_client_t* PopRawClient();
        void PushRawClient(mongoc_client_t* client);

    private:
        mongoc_client_pool_t* Pool;
        mongoc_uri_t* Uri;
    };
}
