#pragma once

#include <search/config/preprocessor/preprocessor.h>

#include <util/generic/hash.h>
#include <util/generic/vector.h>

class TConfigPatcher {
public:
    TConfigPatcher(const TString& patchPrefix = "");
    TString ReadAndProcess(const TString& filename);
    void ReadEnvironment(const TString& filename, bool push = true);
    void ReReadEnvironment();
    void SetVariable(const TString& name, const TString& value);
    void SetUndefinedVariable(const TString& name, const TString& value);
    void AddPatch(const TString& path, const TString& value);
    TConfigPreprocessor* GetPreprocessor() {
        return &Preprocessor;
    }
    void SetStrict(bool value = true) {
        Preprocessor.SetStrict(value);
    }

    const THashMap<TString, TString>& GetVariables() const;
    void SetVariables(const THashMap<TString, TString>& variables);

private:
    TConfigPreprocessor Preprocessor;
    THashMap<TString, TString> Patches;
    TString PatchPrefix;
    TVector<TString> EnvironmentFiles;
    THashMap<TString, TString> Variables;
};
