#include "queue.h"

TOptionalRTYMtpQueue::TOptionalRTYMtpQueue(bool smart, const TString& name) {
    if (smart) {
        Slave.Reset(new TThreadPoolBinder<TRTYMtpQueue, TOptionalRTYMtpQueue>(this, TRTYMtpQueue::TOptions().SetThreadName(name)));
    } else {
        Slave.Reset(new TThreadPoolBinder<TSimpleThreadPool, TOptionalRTYMtpQueue>(this, name));
    }
}

bool TOptionalRTYMtpQueue::Add(IObjectInQueue* obj) {
    return Slave->Add(obj);
}

void TOptionalRTYMtpQueue::Start(size_t threadCount, size_t queueSizeLimit /*= 0*/) {
    Slave->Start(threadCount, queueSizeLimit);
}

void TOptionalRTYMtpQueue::Stop() noexcept {
    Slave->Stop();
}

size_t TOptionalRTYMtpQueue::Size() const noexcept {
    return Slave->Size();
}
