#pragma once

#include "smartqueue.h"

#include <util/generic/ptr.h>

typedef NUtil::TSmartMtpQueue TRTYMtpQueue;

class TOptionalRTYMtpQueue : public IThreadPool {
public:
    TOptionalRTYMtpQueue(bool smart, const TString& name = {});
    [[nodiscard]] virtual bool Add(IObjectInQueue* obj) override;
    virtual void Start(size_t threadCount, size_t queueSizeLimit = 0) override;
    virtual void Stop() noexcept override;
    virtual size_t Size() const noexcept override;
private:
    THolder<IThreadPool> Slave;
};

inline TAutoPtr<IThreadPool> CreateRTYQueue(size_t threads, size_t size = 0, const NUtil::TSmartMtpQueue::TOptions& options = Default<NUtil::TSmartMtpQueue::TOptions>()) {
    TAutoPtr<IThreadPool> queue(new NUtil::TSmartMtpQueue(options));
    queue->Start(threads, size);
    return queue;
}

inline TAutoPtr<IThreadPool> CreateRTYQueue(size_t threads, const TString& threadName) {
    return CreateRTYQueue(threads, 0, NUtil::TSmartMtpQueue::TOptions().SetThreadName(threadName));
}

template <class T>
inline TAutoPtr<IThreadPool> CreateRTYQueueBinder(T* bound, size_t threads, size_t size = 0, const NUtil::TSmartMtpQueue::TOptions& options = Default<NUtil::TSmartMtpQueue::TOptions>()) {
    typedef TThreadPoolBinder<NUtil::TSmartMtpQueue, T> TQueueType;
    TAutoPtr<IThreadPool> queue(new TQueueType(bound, options));
    queue->Start(threads, size);
    return queue;
}
