#pragma once

#include <util/generic/vector.h>
#include <util/generic/string.h>
#include <util/string/vector.h>

namespace NUtil {

struct TMappedRegionInfo {
    void* Ptr = nullptr;
    size_t Size = 0;
    TString File;
    bool IsDeleted = false;
    bool Shared = false;
    bool Writable = false;
};

TVector<TMappedRegionInfo> GetMappedRegions(int pid);
TVector<TString> GetDescriptorsInUsage(int pid);
}
