#include "stream_digest.h"

#include <library/cpp/logger/global/global.h>

TMD5ProxyStream::TMD5ProxyStream(IOutputStream& slave)
    : Slave(slave)
{
}

void TMD5ProxyStream::DoWrite(const void* buf, size_t len) {
    Digest.Update(buf, len);
    Slave.Write(buf, len);
}

void TMD5ProxyStream::DoFinish() {
    Slave.Finish();
    IsFinished = true;
}

TString TMD5ProxyStream::GetMD5() {
    VERIFY_WITH_LOG(IsFinished, "Checksum should be get after stream is finished");
    char buf[33];
    return Digest.End(buf);
}
