#pragma once
//
// Temporary, will be moved to Util
//
#include <util/system/thread.h>

enum class TScheduling : int {
    Default = 0,
    CpuRt = 1 << 1,
    CpuNormal = 1 << 2,
    CpuBatch = 1 << 3,
    IoIdle = 1 << 10,
};

inline constexpr TScheduling operator|(TScheduling a, TScheduling b) {
    return static_cast<TScheduling>(static_cast<int>(a) | static_cast<int>(b));
}
inline constexpr TScheduling operator&(TScheduling a, TScheduling b) {
    return static_cast<TScheduling>(static_cast<int>(a) & static_cast<int>(b));
}
inline constexpr bool operator!(TScheduling a) {
    return TScheduling::Default == a;
}

int SetSchedOpts(TScheduling opts, int nice) noexcept;
