#pragma once

//
// Temporary, will be moved to Util
//

#include <saas/util/thread.h>
#include <util/thread/pool.h>
#include <util/generic/maybe.h>

class TPriorityThreadPool: public IThreadFactory {
public:
    TPriorityThreadPool(TScheduling opts, int cpuNice, TMaybe<bool> allocEnabled = TMaybe<bool>());

    static constexpr bool ValidateOpts(TScheduling opts) {
        // Realtime is mutually exclusive with any other option
        return !!(opts & TScheduling::CpuRt) != (opts == TScheduling::CpuRt) || !(opts & TScheduling::CpuRt);
    }

private:
    virtual IThreadFactory::IThread* DoCreate() override;

public:
    // Internal representation
    struct TThreadScheduling final {
        // CPU and IO classes
        TScheduling Class;

        //ThreadDisableBalloc(). As of 2018-04-19, no other allocator has supported per-thread on/off
        TMaybe<bool> NoAlloc;

        // CPU nice value
        int CpuNice;
    };

private:
    TThreadScheduling Opts_;
};
