#!/home/zomb-sandbox/venv/bin/python

import gevent
import gevent.monkey
# Patch threading and socket modules to allow async operations within :module:`api.copier`.
# Also, this allows asynchronous operations on :module:`requests` objects, which is used in :module:`common.rest`.
gevent.monkey.patch_all(Event=True)
import gevent.hub

import os
import sys
import signal
import logging
import functools as ft

SANDBOX_DIR = os.path.realpath(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__)))))
sys.path = [os.path.dirname(SANDBOX_DIR), SANDBOX_DIR] + sys.path

from kernel.util import console

from sandbox.common import os as common_os
from sandbox.common import log as common_log
from sandbox.common import system as common_system
from sandbox.common import threading as common_threading
from sandbox.common import statistics as common_statistics

import sandbox.agentr.types
import sandbox.agentr.utils
import sandbox.agentr.config
import sandbox.agentr.daemon
import sandbox.agentr.errors

import sandbox.common.types.misc as ctm


def main(config=None):
    if not common_system.inside_the_binary():
        from sandbox import common
        common.process.run_as_root()
    users = common_os.User.service_users

    sandbox.agentr.utils.ProjectQuota.check_support()

    console.setProcTitle(sandbox.agentr.types.PROCESS_TITLE_PREFIX)
    with common_os.User.Privileges(users.service.login):
        # Set HOME for OS X
        os.environ["HOME"] = users.service.home
        # Fix `PATH` environment variable - it can be almost empty (SANDBOX-4616)
        if "/usr/bin" not in os.environ["PATH"].split(":"):
            os.environ["PATH"] = "/sbin:/bin:/usr/sbin:/usr/bin:" + os.environ["PATH"]
        # setup logging
        config = config or sandbox.agentr.config.Registry()
        handler = os.path.join(config.agentr.log.root, config.agentr.log.name)
        if config.common.installation not in ctm.Installation.Group.LOCAL:
            handler = logging.handlers.WatchedFileHandler(handler)
        common_statistics.Signaler(common_statistics.SignalHandlerForAgentR(), component=ctm.Component.AGENTR)
        logger = common_log.setup_log(handler, config.agentr.log.level)
        ex = sandbox.agentr.errors.AgentrRestart()
        logger.info(
            "Initializing %s root privileges, service user is %r. PID is %d",
            "WITH" if common_os.User.has_root else "without", users.service, os.getpid(),
            exc_info=(type(ex), ex, None)
        )

        daemon = sandbox.agentr.daemon.Daemon(config, users)

        def sighandler(ev=None, daemon=daemon):
            console.setProcTitle(sandbox.agentr.types.PROCESS_TITLE_PREFIX + " (finishing...)")
            daemon._stopping.set(ev)

        gevent.hub.signal(signal.SIGINT, ft.partial(sighandler, daemon.Event.STOP_GRACEFULLY))
        gevent.hub.signal(signal.SIGTERM, ft.partial(sighandler, daemon.Event.STOP_HARDLY))
        gevent.hub.signal(signal.SIGUSR2, lambda *_: common_threading.dump_greenlet_threads())
        daemon.start()
        daemon.loop()


if __name__ == "__main__":
    main()
