import py

from sandbox.common import fs
from sandbox.common import joint
from sandbox.common import config


class Registry(config.Registry):
    @property
    def _base(self):
        return super(Registry, self)._base, py.path.local(__file__).dirpath().dirpath("etc", ".settings.yaml")


class Context(joint.Context):
    def __init__(self, settings):
        super(Context, self).__init__(settings.agentr.daemon)
        self.token = (
            fs.read_settings_value_from_file(settings.client.auth.oauth_token)
            if settings.client.auth.oauth_token else
            None
        )
