import sandbox.common.joint.errors


class ARException(Exception):
    """ Base class for internal exceptions of the AgentR """


class WorkerFailed(ARException):
    """ Raised when a worker process returns non-zero return code """


class TaskInProgress(ARException):
    """ Raised in case of ease mode requested by there's task(s) still in progress """


class NoTaskSession(ARException, sandbox.common.joint.errors.SilentException):
    """
    A method which is designed to operate in task session scope called
    on a connection without any task scope associated
    """


class UserDismissed(ARException):
    """ Impossible to validate dismissed user """


class InvalidResource(ARException):
    """ The resource requested metadata does not exist or its state is invalid. """


class InvalidData(ARException):
    """ The resource's data files missing or corrupted. """


class InvalidImage(InvalidData):
    """ The image provided is invalid. """


class InvalidBindMount(WorkerFailed):
    """ Invalid src or dst dirs"""


class ResourceNotAvailable(ARException):
    """ The resource requested is not available at all sources. """


class NoSpaceLeft(ARException):
    """ No space to store a resource. """


class MaintenanceLimitExceeded(ARException):
    """ Self-service limit exceeded. """


class PushClientUnavailable(ARException):
    """ Cannot find config for statbox-push-client """


class InvalidPlatform(ARException):
    """ Function called isn't supported on current platform """


class CopierError(ARException):
    """ Unspecified error from Skynet Copier """


class XcodeError(ARException):
    """ Unspecified error from Xcode installation """


class AgentrRestart(ARException):
    """ Used for statistics signal of restarting of the AgentR only """


class ContainerNotFound(ARException):
    """ Used for raise signal that there is no such porto container """


class UmountError(ARException):
    """ Error while umount some things """
    def __init__(self, lxc=None):
        # Call the base class constructor with the parameters it needs
        super(ARException, self).__init__()
        self.lxc = lxc
