CREATE TABLE "resource" (
  "id"            INTEGER NOT NULL, -- resource ID
  "type"          TEXT NOT NULL,    -- resource type
  "size"          INTEGER NOT NULL, -- resource size in bytes
  "status"        TEXT NOT NULL,    -- resource status (last seen)
  "fetched"       TEXT NOT NULL,    -- date and time the resource has been fetched on the host
  "updated"       TEXT NOT NULL,    -- date and time the resource metadata has been updated
  "checked"       TEXT NOT NULL,    -- date and time the resource data has been checked last time
  "expires"       TEXT,             -- date and time the resource __could__ expire
  "cache_expires" TEXT,             -- date and time local copy of the resource can be removed
  "skynet_id"     TEXT,             -- skynet ID (rbtorrent) of the resource
  "bucket"        INTEGER,          -- bucket (RAID) ID the resource is located in
  "meta"          TEXT NOT NULL,    -- resource metadata (JSON) fetched from the server

  PRIMARY KEY ("id") ON CONFLICT ABORT
);
CREATE INDEX "idx__resource__type"          ON "resource" ("type");
CREATE INDEX "idx__resource__status"        ON "resource" ("status");
CREATE INDEX "idx__resource__updated"       ON "resource" ("updated");
CREATE INDEX "idx__resource__checked"       ON "resource" ("checked");
CREATE INDEX "idx__resource__skynet_id"     ON "resource" ("skynet_id");
CREATE INDEX "idx__resource__bucket"        ON "resource" ("bucket");
CREATE INDEX "idx__resource__cache_expires" ON "resource" ("cache_expires");
