CREATE TABLE "task" (
  "id"              INTEGER NOT NULL, -- task ID
  "session"         TEXT NOT NULL,    -- task session ID
  "lxc"             TEXT,             -- LXC container name the task executed in (if any)
  "iteration"       INTEGER NOT NULL, -- task execution iteration number
  "reserved"        INTEGER NOT NULL, -- task working directory space reservation amount
  "meta"            TEXT NOT NULL,    -- task JSON metadata given from REST API
  "state"           TEXT,             -- task client job state
  "fileserver_meta" TEXT,             -- task commands for fileserver (ps/shell/...)
  "executor_pid"    INTEGER,          -- executor's PID

  PRIMARY KEY ("id") ON CONFLICT ABORT
);

CREATE INDEX "idx__task__session" ON "task" ("session");
