-- Registered task dependencies
CREATE TABLE "task_deps" (
  "task"      INTEGER NOT NULL,           -- resource's task ID
  "resource"  INTEGER NOT NULL,           -- resource ID
  "fetched"   INTEGER NOT NULL DEFAULT 0, -- enumeration (see `agentr.types.DependencyFetch`)
                                          --   - 0 means resource was declared but not even tried to fetch;
                                          --   - 1 for declared and requested to fetch but it was found in local cache;
                                          --   - 2 for declared and really fetched (not found locally);
                                          --   - 3 for NOT declared but requested and it was found in local cache;
                                          --   - 4 for NOT declared and fetched (not found locally) resources.

  PRIMARY KEY ("task", "resource") ON CONFLICT ABORT,
  FOREIGN KEY ("task") REFERENCES "task" ("id") ON UPDATE CASCADE
);

CREATE INDEX "idx__task_deps__task" ON "task_deps" ("task");
