-- Task session disk usage information
CREATE TABLE "task_disk" (
  "task"        INTEGER NOT NULL,           -- Task ID
  "start"       INTEGER NOT NULL,           -- disk usage at task start
  "last"        INTEGER NOT NULL DEFAULT 0, -- last seen disk usage
  "max"         INTEGER NOT NULL DEFAULT 0, -- max disk usage
  "work_start"  INTEGER NOT NULL DEFAULT 0, -- working directory disk usage at task start
  "work_last"   INTEGER NOT NULL DEFAULT 0, -- last seen task working directory disk usage
  "work_max"    INTEGER NOT NULL DEFAULT 0, -- max task working directory disk usage
  "resources"   INTEGER NOT NULL DEFAULT 0, -- size of downloaded resources but not registered as dependencies

  PRIMARY KEY ("task") ON CONFLICT ABORT,
  FOREIGN KEY ("task") REFERENCES "task" ("id") ON UPDATE CASCADE
);
