-- Task session disk monitoring information
CREATE TABLE "task_monitoring" (
  "task"          INTEGER NOT NULL, -- Task ID
  "syslog_inode"  INTEGER,          -- system log inode number at the task start
  "syslog_offset" INTEGER,          -- system log size at the task start
  "atop_pid"      INTEGER,          -- task's atop PID
  "tcpdump_pid"   INTEGER,          -- task's tcpdump PID
  "peak_dumped"   INTEGER,          -- whether peak disk usage has been dumped

  PRIMARY KEY ("task") ON CONFLICT ABORT,
  FOREIGN KEY ("task") REFERENCES "task" ("id") ON UPDATE CASCADE
);
