-- Registered, but not yet completed resources per task
CREATE TABLE "task_resource" (
  "resource"  INTEGER NOT NULL, -- resource ID
  "task"      INTEGER NOT NULL, -- resource's task ID
  "type"      TEXT NOT NULL,    -- resource type
  "updated"   TEXT NOT NULL,    -- date and time the resource metadata has been updated
  "path"      TEXT NOT NULL,    -- resource data full path
  "meta"      TEXT NOT NULL,    -- resource metadata (JSON) fetched from the server
  "share"     INTEGER NOT NULL, -- boolean, flags the resource should be shared on completing it
  "service"   INTEGER NOT NULL, -- boolean, flags the resource is service (ignore on failing the task)

  PRIMARY KEY ("resource") ON CONFLICT ABORT,
  FOREIGN KEY ("task") REFERENCES "task" ("id") ON UPDATE CASCADE
);

CREATE INDEX "idx__task_resource__task" ON "task_resource" ("task");
