-- Registered log files to be processed by LogBroker's "push client"
CREATE TABLE "task_push_logs" (
  "name"  TEXT NOT NULL,    -- log file name
  "task"  INTEGER NOT NULL, -- task ID
  "type"  TEXT NOT NULL,    -- log type

  PRIMARY KEY ("name") ON CONFLICT ABORT,
  FOREIGN KEY ("task") REFERENCES "task" ("id") ON UPDATE CASCADE
);

CREATE INDEX "idx__task_push_logs__task" ON "task_push_logs" ("task");
