-- Registered processes for coredump tracking
CREATE TABLE IF NOT EXISTS "task_process" (
  "pid"       INTEGER NOT NULL, -- process ID
  "cgroup"    TEXT,             -- process cgroup
  "task"      INTEGER NOT NULL, -- task ID
  "coredump"  TEXT,             -- path to core dump if exists

  PRIMARY KEY ("pid", "task") ON CONFLICT ABORT,
  FOREIGN KEY ("task") REFERENCES "task" ("id") ON UPDATE CASCADE
);

CREATE INDEX IF NOT EXISTS "idx__task_process__task" ON "task_process" ("task");
CREATE INDEX IF NOT EXISTS "idx__task_process__pid__cgroup" ON "task_process" ("pid", "cgroup");
