-- System logs that need to be monitored

CREATE TABLE IF NOT EXISTS "task_monitoring_log" (
  "task"     INTEGER NOT NULL,                   -- Task ID
  "path"     TEXT,                               -- path to log file
  "label"    TEXT,                               -- filename the cut log will be saved as
  "inode"    INTEGER,                            -- system log inode number at the start
  "offset"   INTEGER,                            -- system log size at the task start

  FOREIGN KEY ("task") REFERENCES "task" ("id") ON UPDATE CASCADE
);

CREATE INDEX IF NOT EXISTS "idx__task_monitoring_log__task" ON "task_monitoring_log" ("task");
