-- Ongoing task actions and their current state.
-- For progress_meta's schema, head on to sdk2.helpers.misc.ProgressMeter.current

CREATE TABLE IF NOT EXISTS "action" (
  "id"          TEXT NOT NULL,            -- action identifier (UUID)
  "task"        INTEGER NOT NULL,         -- task identifier
  "message"     TEXT NOT NULL,            -- action progress metadata, serialized as JSON
  "started"     TEXT NOT NULL,            -- action start time, ISO8601 format
  "current"     TEXT,                     -- text representation of current value (e.g. "1 MiB")
  "total"       TEXT,                     -- text representation value considered as 100% (e.g. "100 MiB")
  "percentage"  INTEGER,                  -- current progress (0..100)

  PRIMARY KEY ("id") ON CONFLICT ABORT
  FOREIGN KEY ("task") REFERENCES "task" ("id") ON DELETE CASCADE
);

CREATE INDEX IF NOT EXISTS "idx__action__task" ON "action" ("task");
