-- Mounts are performed by executing task
-- Mount sequence tracked by service `rowid` column

CREATE TABLE IF NOT EXISTS "task_mount" (
  "task"    INTEGER NOT NULL, -- Task ID
  "type"    TEXT NOT NULL,    -- mount type
  "target"  TEXT NOT NULL,    -- destination path - mount point
  "source"  TEXT NOT NULL,    -- source path (image path, overlayed directories, etc)

  FOREIGN KEY ("task") REFERENCES "task" ("id") ON UPDATE CASCADE
);

CREATE INDEX IF NOT EXISTS "idx__task_mount__task" ON "task_mount" ("task");
