-- Version 5->4 downgrade script
-- it is not allowed to DROP COLUMN in sqlite, so we have to recreate table without that column

BEGIN TRANSACTION;

ALTER TABLE "task" RENAME TO "temp_task";
DROP INDEX IF EXISTS "idx__task__session";

CREATE TABLE "task" (
  "id"            INTEGER NOT NULL,           -- task ID
  "session"       TEXT NOT NULL,              -- task session ID
  "iteration"     INTEGER NOT NULL,           -- task execution iteration number
  "reserved"      INTEGER NOT NULL,           -- task working directory space reservation amount
  "meta"          TEXT NOT NULL,              -- task JSON metadata given from REST API

  PRIMARY KEY ("id") ON CONFLICT ABORT
);

CREATE INDEX "idx__task__session" ON "task" ("session");

INSERT INTO "task"
SELECT "id", "session", "iteration", "reserved", "meta"
FROM "temp_task";

DROP TABLE "temp_task";

COMMIT;
