def migrate(db, *_):
    new_columns = ("cgroup",)
    columns = {column[1] for column in db.query("pragma table_info(task_process)")}
    for column in new_columns:
        if column not in columns:
            db.execute_script('ALTER TABLE "task_process" ADD COLUMN "{}" TEXT'.format(column))
    db.execute_script('CREATE INDEX IF NOT EXISTS "idx__task_process__pid__cgroup" ON "task_process" ("pid", "cgroup")')
