def migrate(db, *_):
    new_columns = ("cache_expires",)
    columns = {column[1] for column in db.query("pragma table_info(resource)")}
    for column in new_columns:
        if column not in columns:
            db.execute_script('ALTER TABLE "resource" ADD COLUMN "{}" TEXT'.format(column))

    import datetime
    import random
    import sandbox.agentr.types
    random_spread = random.randint(0, 12)  # random spread
    expiration_date = datetime.datetime.utcnow() + datetime.timedelta(days=1) + datetime.timedelta(hours=random_spread)
    expiration = expiration_date.strftime(sandbox.agentr.types.DT_FMT)
    db.execute_script('UPDATE "resource" SET "cache_expires" = "{}" WHERE "cache_expires" IS NULL'.format(expiration))
    db.execute_script('CREATE INDEX IF NOT EXISTS "idx__resource__cache_expires" ON "resource" ("cache_expires")')
