"""
echo "|<...>/python <...>/coredumper.py %e %p %g %u %s %P %c" >/proc/sys/kernel/core_pattern
"""
from __future__ import absolute_import

import os
import sys
import logging

ROOT_DIR = reduce(lambda p, _: os.path.dirname(p), xrange(2), os.path.abspath(__file__))  # noqa
sys.path = ["/skynet", os.path.dirname(ROOT_DIR), ROOT_DIR] + sys.path  # noqa

import sandbox.agentr.client

CHUNK_SIZE = 8 << 20

if __name__ == "__main__":
    name, pid, gid, uid, sig, rpid = sys.argv[1:7]

    if len(sys.argv) == 8:
        if sys.argv[7] == "unlimited":
            core_limit = None
        else:
            core_limit = min(int(sys.argv[7]), sys.maxint)
    else:
        core_limit = None

    filename = ".".join((name, pid, sig))
    agentr = sandbox.agentr.client.Service(logging.getLogger())
    coredump_path = agentr.register_coredump(pid, filename, rpid, core_limit=core_limit, base_filename=name)

    if core_limit == 0:
        exit(0)

    tmp_coredump_path = coredump_path + "~"
    size = 0
    with open(tmp_coredump_path, "wb") as f:
        while True:
            chunk = sys.stdin.read(CHUNK_SIZE)
            size += len(chunk)
            if core_limit is not None and size > core_limit:
                break
            if not chunk:
                break
            f.write(chunk)

    if core_limit is not None and size > core_limit:
        os.unlink(tmp_coredump_path)
    else:
        os.chown(tmp_coredump_path, int(uid), int(gid))
        os.rename(tmp_coredump_path, coredump_path)
