import os
import logging


class _Logger(logging.getLoggerClass()):
    class LogRecord(logging.LogRecord):
        __module_cache = {}

        def __init__(self, name, level, pathname, lineno, msg, args, exc_info, func=None):
            super(_Logger.LogRecord, self).__init__(name, level, pathname, lineno, msg, args, exc_info, func=func)
            self.module = self.__module_cache.get(self.pathname)
            if self.module is None:
                path_items = self.pathname.split(os.sep)
                path_items[-1] = path_items[-1].rsplit(".", 1)[0]
                if path_items[-1] == "__init__":
                    path_items[:] = path_items[:-1]
                self.__module_cache[self.pathname] = self.module = ".".join(path_items[-2:])

    def makeRecord(self, name, level, fn, lno, msg, args, exc_info, func=None, extra=None):
        return self.LogRecord(name, level, fn, lno, msg, args, exc_info, func)

logging.setLoggerClass(_Logger)


from . import base
from . import errors
from . import pinger
from . import system
from . import network

from . import commands
from . import platforms


__all__ = (
    "base",
    "errors",
    "pinger",
    "system",
    "network",

    "commands",
    "platforms",
)
