from __future__ import print_function
from __future__ import absolute_import

import os
import sys
import logging

from sandbox.common import os as common_os

import sandbox.client as sc
from sandbox.client.bin import launch


logger = logging.getLogger("client")


def main():
    launch.prepare_main_process()

    with common_os.User.Privileges(sc.system.SERVICE_USER.login, limit=False):
        launch.check_client_stop()

        # Set HOME for OS X
        os.environ["HOME"] = sc.system.SERVICE_USER.home
        try:
            launch.initialize()
            launch.log_system_info()
            launch.start()
            os._exit(-2)
        except Exception:
            if logger.handlers:
                logger.exception("Error during client initialization.")
            print("Error during client initialization.", file=sys.stderr)
            import traceback
            traceback.print_exc(file=sys.stderr)
            os._exit(1)


if __name__ == "__main__":
    main()
