from . import base


class StatusException(BaseException, base.Serializable):
    """ Used to serialize status values to JSON"""
    @classmethod
    def __getstate__(cls):
        return None


class ExecutorFailed(StatusException):
    """ Raises if executor process is failed """


class ContainerError(StatusException):
    """ Raises if container is corrupted """


class InfraError(StatusException):
    """ Raised on infrastructure problems: staring container, mounting FS, etc """
    def __init__(self, message=None, stdout="", stderr="", returncode=None):
        args = []
        if message is not None:
            args.append(message)
        super(InfraError, self).__init__(*args)
        self.stdout = stdout
        self.stderr = stderr
        self.returncode = returncode


class WindowsCleanupError(InfraError):
    """ Raised on windows-specific cleanup problems. Host redeplooy required for recover """


class CriticalInfraError(InfraError):
    """ Raised on critical infrastructure problems: host reboot is required for recovering """


class SessionExpired(StatusException):
    """ Signals to drop a job without termination """


class ShuttingDown(StatusException):
    """ Used to cancel jobs on client shutdown """


class InvalidJob(StatusException):
    """ Job has incorrect settings, switches task to EXCEPTION """


class ContainerTemporaryError(Exception):
    """ Container temporary error on start """


class RcLocalError(ContainerTemporaryError):
    """ rc.local failed error """


class InvalidCGroups(ContainerTemporaryError):
    """ CGroups have invalid names """
