from __future__ import absolute_import

import six


class ImmutableDict(dict):
    def __setitem__(self, *_):
        raise NotImplementedError

    def __setattr__(self, *_):
        raise NotImplementedError

    def __delitem__(self, *_):
        raise NotImplementedError

    def clear(self):
        raise NotImplementedError

    def pop(self, *_, **__):
        raise NotImplementedError

    def popitem(self):
        raise NotImplementedError

    def setdefault(self, *_, **__):
        raise NotImplementedError

    def update(self, *_, **__):
        raise NotImplementedError


# noinspection PyAbstractClass
class ImmutableOrderedDict(ImmutableDict):
    # noinspection PyMissingConstructor
    def __init__(self, items):
        keys = []
        for item in six.iteritems(items):
            keys.append(item[0])
            dict.update(self, (item,))
        object.__setattr__(self, "__keys__", tuple(keys))

    def __iter__(self):
        # noinspection PyUnresolvedReferences
        return iter(self.__keys__)

    def __reversed__(self):
        # noinspection PyUnresolvedReferences
        return reversed(self.__keys__)

    def keys(self):
        return list(self)

    def values(self):
        return [self[k] for k in self]

    def items(self):
        return [(k, self[k]) for k in self]

    def iterkeys(self):
        return iter(self)

    def itervalues(self):
        for k in self:
            yield self[k]

    def iteritems(self):
        for k in self:
            yield (k, self[k])


class AttrDictMeta(type):
    # noinspection PyMethodParameters
    def __new__(msc, name, bases, namespace):
        base = bases[0]
        namespace["__getattr__"] = base.__getitem__
        namespace["__setattr__"] = base.__setitem__
        namespace["__delattr__"] = base.__delitem__
        return type.__new__(msc, name, bases, namespace)


@six.add_metaclass(AttrDictMeta)
class AttrDict(dict):
    pass


# noinspection PyAbstractClass
@six.add_metaclass(AttrDictMeta)
class ImmutableAttrDict(ImmutableDict):
    pass


# noinspection PyAbstractClass
@six.add_metaclass(AttrDictMeta)
class ImmutableAttrOrderedDict(ImmutableOrderedDict):
    pass
