from __future__ import absolute_import, unicode_literals

import msgpack

import six


def force_int(value, default=0):
    try:
        return int(value)
    except (TypeError, ValueError):
        return default


def load_yaml(data):
    """
    Importing yaml takes a long time, so it's moved from module-level import to runtime
    """
    import yaml
    try:
        from yaml import CLoader as YamlLoader
    except ImportError:
        from yaml import Loader as YamlLoader
    return yaml.load(data, Loader=YamlLoader)


def msgpack_unpacker(**kws):
    max_value = 2147483647
    unpacker_kws = dict(
        max_str_len=max_value,
        max_bin_len=max_value,
        max_array_len=max_value,
        max_map_len=max_value,
        max_ext_len=max_value,
    )
    unpacker_kws.update(kws)
    return msgpack.Unpacker(**unpacker_kws)


def obj_to_int(obj):
    if isinstance(obj, int):
        return obj
    elif isinstance(obj, six.string_types):
        try:
            return int(obj)
        except ValueError:
            raise ValueError("Can't convert '{}' to valid ID".format(obj))
    try:
        return obj.id
    except AttributeError:
        raise AttributeError("Can't convert '{}' to valid ID".format(obj))
