from __future__ import absolute_import, print_function, unicode_literals

import sys

import six

try:
    from html import escape as escape_html
except ImportError:
    from cgi import escape as escape_html


def force_unicode(s, encoding="utf-8", errors="strict"):
    """
    Returns a text object representing 's' -- unicode on Python 2 and str on
    Python 3. Treats bytestrings using the 'encoding' codec.

    (copied from Django 1.11.21 with some framework-specific code omitted)
    """

    # Handle the common case first for performance reasons.
    if issubclass(type(s), six.text_type):
        return s

    try:
        if not issubclass(type(s), six.string_types):
            if six.PY3:
                if isinstance(s, bytes):
                    s = six.text_type(s, encoding, errors)
                else:
                    s = six.text_type(s)
            elif hasattr(s, "__unicode__"):
                s = six.text_type(s)
            else:
                s = six.text_type(bytes(s), encoding, errors)
        else:
            s = s.decode(encoding, errors)
    except UnicodeDecodeError:
        if not isinstance(s, Exception):
            raise
        else:
            # If we get to here, the caller has passed in an Exception
            # subclass populated with non-ASCII bytestring data without a
            # working unicode method. Try to handle this without raising a
            # further exception by individually forcing the exception args
            # to unicode.
            s = " ".join(force_unicode(arg, encoding, errors) for arg in s.args)
    return s


def force_unicode_safe(s):
    return force_unicode(s, errors="replace")


def escape(html):
    """ Returns the given HTML with ampersands, quotes and angle brackets encoded. """
    return escape_html(force_unicode(html), quote=False)


def setup_default_encoding():
    if six.PY3:
        return

    # Enable python3-like default string encoding rules (SANDBOX-6872)
    if sys.getdefaultencoding() != "utf-8":
        # noinspection PyCompatibility
        reload(sys)  # noqa
        # noinspection PyUnresolvedReferences
        sys.setdefaultencoding("utf-8")
