package main

import (
	"fmt"
	"log"
	"os"
	"os/user"
	"path/filepath"
	"strings"

	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"

	apiclient "a.yandex-team.ru/sandbox/common/go/clients"
	"a.yandex-team.ru/sandbox/common/go/clients/client"
	"a.yandex-team.ru/sandbox/common/go/clients/group"
)

func main() {

	token := os.Getenv("SANDBOX_TOKEN")
	var auth runtime.ClientAuthInfoWriter
	if token == "" {
		usr, _ := user.Current()

		tokenPath := filepath.Join(usr.HomeDir, ".sandbox", "token")
		bs, err := os.ReadFile(tokenPath)
		if err == nil {
			token = strings.TrimSpace(string(bs))
		}
	}
	if token != "" {
		auth = httptransport.APIKeyAuth("Authorization", "header", "OAuth "+strings.TrimSpace(token))
	}
	cfg := apiclient.DefaultTransportConfig()
	transport := httptransport.New(cfg.Host, cfg.BasePath, cfg.Schemes)
	transport.Debug = true

	apiclient.Default.SetTransport(transport)
	{
		// make the request to get all items
		req := client.NewClientListGetParams()
		req.Limit = 10
		b := true
		req.SetAlive(&b)

		resp, err := apiclient.Default.Client.ClientListGet(req) // No auth
		if err != nil {
			log.Fatal(err)
		}
		fmt.Println("Alive agents (first 10)")
		for _, item := range resp.GetPayload().Items {
			fmt.Printf("Id: %q, Fqdn: %q, Alive: %v\n", item.ID, item.Fqdn, item.Alive)
		}
	}

	{
		req := group.NewGroupGetParams().WithName("YT")
		{
			_, err := apiclient.Default.Group.GroupGet(req, nil)
			if err == nil {
				log.Fatal("No error without auth")
			}
			if conv, ok := err.(*runtime.APIError); !ok {
				panic(err)
			} else {
				fmt.Printf("CODE: %v\n", conv.Code)
			}
		}

		// Add default auth
		transport.DefaultAuthentication = auth
		resp, err := apiclient.Default.Group.GroupGet(req, nil)
		if err != nil {
			log.Fatalf("Group get failed: %v", err)
		}

		fmt.Printf(
			"===\nName: %v\n Members: %v\n",
			resp.GetPayload().Name,
			resp.GetPayload().Members,
		)

		fmt.Printf("Users:\n")
		for k, v := range resp.GetPayload().Users {
			fmt.Printf("    %v: %v\n", k, v)
		}

	}

	// Invalid group
	{
		req := group.NewGroupGetParams().WithName("INVALID_GROUP_DOES_NOT_EXIST")
		{
			_, err := apiclient.Default.Group.GroupGet(req, nil)
			if _, ok := err.(*group.GroupGetNotFound); !ok {
				panic(err)
			}
		}

	}

}
