PY3_PROGRAM(lazy-gen)

IF(OS_WINDOWS)
    SET(exe_ext .exe)
ELSE()
    SET(exe_ext)
ENDIF()

SET(
    swagger_root vendor/github.com/go-swagger/go-swagger/cmd/swagger
)
SET(
    swagger_tool ${swagger_root}/swagger${exe_ext}
)

SET(
    mockgen_root vendor/github.com/golang/mock/mockgen
)

SET(
    mockgen_tool ${mockgen_root}/mockgen${exe_ext}
)

SET(
    code_archive code_archive.tar.gz
)

#${BINDIR}
SET(
    OUTPUT_DIR sandbox/common/go/make/lazy_gen
)

RUN_PROGRAM(
    sandbox/common/go/make/swag_gen
    --build-output=${OUTPUT_DIR}
    --go-package=sandbox/common/go
    --swagger-tool=${swagger_tool}
    --mockgen-tool=${mockgen_tool}
    --code-archive=${code_archive}
    # --debug

    TOOL ${swagger_root}
    TOOL ${mockgen_root}
    OUT ${code_archive}
    CWD ${ARCADIA_BUILD_ROOT}
    ENV PATH=${GO_TOOLS_RESOURCE_GLOBAL}/bin
    ENV GOPATH=${GO_TOOLS_RESOURCE_GLOBAL}
)

PEERDIR(
    contrib/python/click
    contrib/python/Jinja2
    library/python/resource
    build/external_resources/go_tools
)

PY_SRCS(
    __main__.py
)


RESOURCE(
    ${code_archive} ${code_archive}
)

END()
