from __future__ import absolute_import

import os
import sys
import importlib

# (DEPRECATED) Backward compatibility
# noinspection PyUnresolvedReferences
from ..context import skip_if_binary  # noqa
from ..system import inside_the_binary  # noqa


class PackageImporter(object):
    """ Import hook that creates virtual package by ignoring given package name in the importing module name. """

    def __init__(self, pkg):
        self.pkg = pkg

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.pkg == other.pkg

    def __ne__(self, other):
        return not self.__eq__(other)

    def realname(self, fullname):
        return "__init__" if fullname == self.pkg else fullname[len(self.pkg) + 1:]

    def find_module(self, fullname, path=None):
        if fullname.split(".", 1)[0] == self.pkg:
            try:
                importlib.import_module(self.realname(fullname))
                return self
            except ImportError:
                pass

    def load_module(self, fullname):
        realname = self.realname(fullname)
        mod = importlib.import_module(realname)
        if realname == "__init__":
            mod.__path__ = [os.path.abspath(os.path.dirname(mod.__file__))]
        sys.modules[fullname] = mod
        return mod

    def is_package(self, module):
        fname = sys.modules[module].__file__
        return fname.endswith("__init__.py") or fname.endswith("__init__.pyc")


def setup_sandbox_namespace():
    # use hook only for non-binary run and for legacy scripts
    if not inside_the_binary() and not getattr(sys.modules["__main__"], "DISABLE_IMPORT_HOOK", None):
        importer = PackageImporter("sandbox")
        sys.meta_path = [importer] + [mp for mp in sys.meta_path if mp != importer]


def lookup_module(fullname):
    """
    Get an imported module by its fullname. Check both import namespaces:

    * for `sandbox.x.y` check also `x.y`;
    * for `x.y` check also `sandbox.x.y`.

    Raise `KeyError` if both attempts are unsuccessful.
    """

    try:
        return sys.modules[fullname]
    except KeyError:
        pass

    prefix, _, suffix = fullname.partition(".")

    if prefix == "sandbox":
        candidate = suffix
    else:
        candidate = "sandbox." + fullname

    try:
        return sys.modules[candidate]
    except KeyError:
        raise KeyError(fullname)
