package ru.yandex.sandbox.client;

import java.util.List;

import retrofit.http.Body;
import retrofit.http.POST;
import retrofit.http.PUT;
import retrofit.http.Path;

import ru.yandex.sandbox.client.api.SandboxBatchResponse;
import ru.yandex.sandbox.client.api.SandboxTask;
import ru.yandex.sandbox.client.api.SandboxUpdateTask;

/**
 * Created by azee on 02.12.16.
 * <p>
 * See https://sandbox.yandex-team.ru/media/swagger-ui/index.html
 */
public interface SandboxClient {

    @POST("/task")
    public SandboxTask createTask(@Body SandboxTask task);

    @PUT("/task/{taskId}")
    public SandboxUpdateTask updateTask(@Body SandboxUpdateTask task, @Path("taskId") String taskId);

    @PUT("/batch/tasks/{operation}")
    public List<SandboxBatchResponse> startTasks(@Body List<Long> objectsList, @Path("operation") String operation);

}
