package ru.yandex.sandbox.client;

import java.io.IOException;

import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SandboxUnavailableInterceptor implements Interceptor {

    private static final Logger logger = LoggerFactory.getLogger(SandboxUnavailableInterceptor.class);

    private final int retries;

    public SandboxUnavailableInterceptor(int retries) {
        this.retries = retries;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);

        int retries = this.retries;
        while (!response.isSuccessful() && isRetryable(response) && retries-- > 0) {
            logger.warn("will proceed request again after error: {}, retries left: {}", response.body().string(), retries);
            response = chain.proceed(request);
        }

        return response;
    }

    private boolean isRetryable(Response response) {
        return response.code() >= 502 && response.code() <= 504;
    }
}
