
package ru.yandex.sandbox.client.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import ru.yandex.sandbox.client.api.notification.NotificationSetting;

/**
 * <p>Java class for SandboxTask complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="SandboxTask">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="id" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="type" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SandboxTask", propOrder = {
    "id",
    "type"
})
@XmlRootElement(name = "sandboxTask")
public class SandboxTask implements Serializable {

    @XmlElement(required = true)
    protected String id;
    @XmlElement(required = true)
    protected String type;

    private String author;
    private String owner;

    private List<SandboxCustomField> customFields = new ArrayList<>();

    private String description;
    private Map<String, Object> context = new HashMap<>();
    private SandboxTaskPriority priority;
    private List<String> tags;

    private List<NotificationSetting> notifications;
    private SandboxTaskRequirements requirements;

    private Long tasksArchiveResource;

    /**
     * Default no-arg constructor
     *
     */
    public SandboxTask() {
        super();
    }

    /**
     * Fully-initialising value constructor
     *
     */
    public SandboxTask(final String id, final String type) {
        this.id = id;
        this.type = type;
    }

    /**
     * Gets the value of the id property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the type property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setType(String value) {
        this.type = value;
    }

    public SandboxTask withId(String value) {
        setId(value);
        return this;
    }

    public SandboxTask withType(String value) {
        setType(value);
        return this;
    }

    public String getAuthor() {
        return author;
    }

    public SandboxTask setAuthor(String author) {
        this.author = author;
        return this;
    }

    public String getOwner() {
        return owner;
    }

    public SandboxTask setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty("custom_fields")
    public List<SandboxCustomField> getCustomFields() {
        return customFields;
    }

    public void setCustomFields(List<SandboxCustomField> customFields) {
        this.customFields = customFields;
    }

    public String getDescription() {
        return description;
    }

    public SandboxTask setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, Object> getContext() {
        return context;
    }

    public SandboxTask setContext(Map<String, Object> context) {
        this.context = context;
        return this;
    }

    public SandboxTaskPriority getPriority() {
        return priority;
    }

    public SandboxTask setPriority(SandboxTaskPriority priority) {
        this.priority = priority;
        return this;
    }

    public List<String> getTags() {
        return tags;
    }

    public SandboxTask setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public List<NotificationSetting> getNotifications() {
        return notifications;
    }

    public void setNotifications(List<NotificationSetting> notifications) {
        this.notifications = notifications;
    }

    public SandboxTaskRequirements getRequirements() {
        return requirements;
    }

    public SandboxTask setRequirements(SandboxTaskRequirements requirements) {
        this.requirements = requirements;
        return this;
    }

    @JsonProperty("tasks_archive_resource")
    @Nullable
    public Long getTasksArchiveResource() {
        return tasksArchiveResource;
    }

    public void setTasksArchiveResource(Long tasksArchiveResource) {
        this.tasksArchiveResource = tasksArchiveResource;
    }
}
