package ru.yandex.sandbox.client.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @author albazh
 */
public class SandboxTaskPriority {

    @JsonProperty("class")
    // it's safer not to use enum here
    private String clazz;
    private String subclass;

    public SandboxTaskPriority() {
        // no-arg constructor for jackson
    }

    public SandboxTaskPriority(PriorityClass clazz, PrioritySubclass subclass) {
        this.clazz = clazz.name();
        this.subclass = subclass.name();
    }

    public String getClazz() {
        return clazz;
    }

    public String getSubclass() {
        return subclass;
    }

    public enum PriorityClass {
        USER, SERVICE, BACKGROUND
    }

    public enum PrioritySubclass {
        LOW, NORMAL, HIGH
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
