package ru.yandex.sandbox.client.api;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Created by azee on 02.12.16.
 */
public class SandboxUpdateTask extends SandboxUpdateTaskBase {

    private String author;
    private String description;
    private SandboxTaskPriority priority;

    @XmlElement(name = "custom_fields")
    @JsonProperty("custom_fields")
    protected List<SandboxCustomField> custom_fields = new LinkedList<>();

    public String getAuthor() {
        return author;
    }

    public SandboxUpdateTask setAuthor(String author) {
        this.author = author;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public SandboxUpdateTask setDescription(String description) {
        this.description = description;
        return this;
    }

    public SandboxTaskPriority getPriority() {
        return priority;
    }

    public SandboxUpdateTask setPriority(SandboxTaskPriority priority) {
        this.priority = priority;
        return this;
    }

    public List<SandboxCustomField> getCustom_fields() {
        return custom_fields;
    }

    public void setCustom_fields(List<SandboxCustomField> custom_fields) {
        this.custom_fields = custom_fields;
    }

    public SandboxUpdateTask withCustom_fields(SandboxCustomField... fields){
        getCustom_fields().addAll(Arrays.asList(fields));
        return this;
    }
}
