JAVA_LIBRARY()

JDK_VERSION(11)

OWNER(
    albazh
)

SET(jackson_version 2.8.6)
SET(retrofit_version 1.9.0)
SET(qatools_yclient_version 1.12)
SET(slf4j_version 1.7.4)
SET(apache_commons_lang 3.7)
SET(findbugs_jsr305_version 3.0.2)

PEERDIR(
    contrib/java/org/slf4j/slf4j-api

    contrib/java/com/google/code/findbugs/jsr305
    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/fasterxml/jackson/core/jackson-annotations

    contrib/java/com/squareup/retrofit/retrofit

    contrib/java/ru/yandex/qatools/yclient-commons

    contrib/java/org/apache/commons/commons-lang3

    # JDK10
    contrib/java/javax/xml/bind/jaxb-api/2.3.0
)

DEPENDENCY_MANAGEMENT(
    contrib/java/org/slf4j/slf4j-api/${slf4j_version}

    contrib/java/com/google/code/findbugs/jsr305/${findbugs_jsr305_version}
    contrib/java/com/fasterxml/jackson/core/jackson-databind/${jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-annotations/${jackson_version}

    contrib/java/com/squareup/retrofit/retrofit/${retrofit_version}

    contrib/java/ru/yandex/qatools/yclient-commons/${qatools_yclient_version}

    contrib/java/org/apache/commons/commons-lang3/${apache_commons_lang}
)

EXCLUDE(
    contrib/java/log4j/log4j
    contrib/java/org/slf4j/slf4j-log4j12
)

JAVA_SRCS(
    PACKAGE_PREFIX ru.yandex.sandbox.client
    SRCDIR src/main/java **/*
)

LINT(base)
END()

RECURSE(ut)
