package ru.yandex.sandbox.client.task;

import java.util.Collections;
import java.util.List;

import ru.yandex.sandbox.client.api.SandboxTask;
import ru.yandex.sandbox.client.api.SandboxTaskPriority;
import ru.yandex.sandbox.client.api.SandboxTaskRequirements;
import ru.yandex.sandbox.client.api.notification.NotificationSetting;
import ru.yandex.sandbox.client.api.notification.NotificationStatus;
import ru.yandex.sandbox.client.api.notification.NotificationTransport;

public class TaskletYaCommitTaskBuilder {

    public static final String TYPE = "TASKLET_YA_COMMIT_TASK";

    private String description = "Tasklet Autocommit after successful precommit check";

    private SandboxTaskPriority priority = new SandboxTaskPriority(
            SandboxTaskPriority.PriorityClass.SERVICE,
            SandboxTaskPriority.PrioritySubclass.HIGH
    );

    private String commitMessage;
    private String commitAuthor;
    private String arcadiaPatch;
    private Boolean dryRun;
    private Boolean expectPrUpdate;

    private List<String> tags = Collections.singletonList("arcanum-autocommit");

    private String svnPath;
    private String svnRevision;

    private Long diffSetId;
    private Long reviewRequestId;

    private long tasksResource;

    public SandboxTask build() {
        SandboxTask task = new YaCommitTaskBuilder()
                .setDescription(description)
                .setPriority(priority)
                .setCommitMessage(commitMessage)
                .setCommitAuthor(commitAuthor)
                .setArcadiaPatch(arcadiaPatch)
                .setDryRun(dryRun)
                .setExpectPrUpdate(expectPrUpdate)
                .setTags(tags)
                .setSvnPath(svnPath)
                .setSvnRevision(svnRevision)
                .build();

        task.setType(TYPE);

        task.setNotifications(Collections.singletonList(
                new NotificationSetting(
                        NotificationTransport.EMAIL,
                        List.of(
                                NotificationStatus.EXCEPTION,
                                NotificationStatus.TIMEOUT
                        ),
                        List.of(
                                commitAuthor,
                                "workfork"
                        )
                )
        ));

        task.setRequirements(new SandboxTaskRequirements()
                .setTasksResource(tasksResource)
        );

        task.getCustomFields().add(new TaskletYaCommitTaskParameter.TaskletName("YaCommitTask"));

        if (diffSetId != null && diffSetId != 0) {
            task.getCustomFields().add(new TaskletYaCommitTaskParameter.DiffSet(diffSetId));
        }

        if (reviewRequestId != null && reviewRequestId != 0) {
            task.getCustomFields().add(new TaskletYaCommitTaskParameter.ReviewRequest(reviewRequestId));
        }

        return task;
    }

    public String getDescription() {
        return description;
    }

    public TaskletYaCommitTaskBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public SandboxTaskPriority getPriority() {
        return priority;
    }

    public TaskletYaCommitTaskBuilder setPriority(SandboxTaskPriority priority) {
        this.priority = priority;
        return this;
    }

    public String getCommitMessage() {
        return commitMessage;
    }

    public TaskletYaCommitTaskBuilder setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
        return this;
    }

    public String getCommitAuthor() {
        return commitAuthor;
    }

    public TaskletYaCommitTaskBuilder setCommitAuthor(String commitAuthor) {
        this.commitAuthor = commitAuthor;
        return this;
    }

    public String getArcadiaPatch() {
        return arcadiaPatch;
    }

    public TaskletYaCommitTaskBuilder setArcadiaPatch(String arcadiaPatch) {
        this.arcadiaPatch = arcadiaPatch;
        return this;
    }

    public Boolean getDryRun() {
        return dryRun;
    }

    public TaskletYaCommitTaskBuilder setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getExpectPrUpdate() {
        return expectPrUpdate;
    }

    public TaskletYaCommitTaskBuilder setExpectPrUpdate(Boolean expectPrUpdate) {
        this.expectPrUpdate = expectPrUpdate;
        return this;
    }

    public List<String> getTags() {
        return tags;
    }

    public TaskletYaCommitTaskBuilder setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public String getSvnPath() {
        return svnPath;
    }

    public TaskletYaCommitTaskBuilder setSvnPath(String svnPath) {
        this.svnPath = svnPath;
        return this;
    }

    public String getSvnRevision() {
        return svnRevision;
    }

    public TaskletYaCommitTaskBuilder setSvnRevision(String svnRevision) {
        this.svnRevision = svnRevision;
        return this;
    }

    public long getTasksResource() {
        return tasksResource;
    }

    public TaskletYaCommitTaskBuilder setTasksResource(long tasksResource) {
        this.tasksResource = tasksResource;
        return this;
    }

    public Long getDiffSetId() {
        return diffSetId;
    }

    public TaskletYaCommitTaskBuilder setDiffSetId(Long diffSetId) {
        this.diffSetId = diffSetId;
        return this;
    }

    public Long getReviewRequestId() {
        return reviewRequestId;
    }

    public TaskletYaCommitTaskBuilder setReviewRequestId(Long reviewRequestId) {
        this.reviewRequestId = reviewRequestId;
        return this;
    }

}
