from __future__ import absolute_import, print_function

import math
import fractions


def percentile(iterable, percent):
    """
    Get `percent`-percentile of given iterable of ints.

    :param iterable: an iterable to calculate percentile. MUST BE SORTED
    :param percent: percentile value, a float in range [0.0, 1.0]
    :return: percentile (int) of given iterable if it's not empty, None otherwise
    :rtype: int or None
    """

    if not iterable:
        return
    k = (len(iterable) - 1) * percent
    floor = math.floor(k)
    ceil = math.ceil(k)
    if floor == ceil:
        return iterable[int(k)]
    item_0 = iterable[int(floor)] * (ceil - k)
    item_1 = iterable[int(ceil)] * (k - floor)
    return int(item_0 + item_1)


def progress(start, current, end):
    """
    Given base, present, and total amount, calculate percentage of resource's completeness or waste.
    A resource may be many things: water in a bottle, a file being transmitted over network, et cetera, et cetera.
    """

    multiplier = 100
    current = min(max(start, current), end)
    try:
        return int(multiplier * fractions.Fraction(current - start, end - start))
    except ZeroDivisionError:
        return multiplier
